create or replace package body tbicds.PCK_APP_MENU2 is

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/****
Get tool bar items
***/
procedure GetToolbarItemsRS(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2,
                              rs                  out sys_refcursor) 
is
  
    v_nUserRights number(12) := 0;
    v_nUserType   number(12) := 0;
    v_bIsLoggedIn boolean := false;
    v_vSQL        varchar2(32767) := '';
  begin
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_bIsLoggedIn := (nvl(pi_nUserID, 0)) > 0;
  
    if v_bIsLoggedIn then
      v_vSQL := 'select user_rights, user_type from tbicds.fx_user_rights where fx_user_id = :P0 ';
      execute immediate v_vSQL into v_nUserRights, v_nUserType using pi_nUserID;
    
      v_vSQL := 'select * ';
      v_vSQL := v_vSQL || 'from tbicds.stat_menu_items t ';
      v_vSQL := v_vSQL || 'where t.active = 1 ';
      --v_vSQL := v_vSQL || 'and t.has_parent = 1 ';
      v_vSQL := v_vSQL || 'and (((bitand(t.user_right, :USER_RIGHTS) > 0) ';
      v_vSQL := v_vSQL || 'or t.user_right = 0) ';
      v_vSQL := v_vSQL || 'and ((bitand(t.user_type, :USER_TYPE) > 0) ';
      v_vSQL := v_vSQL || 'or (t.user_type = 0))) ';
      v_vSQL := v_vSQL || 'and (bitand(2, t.item_type) > 0) ';
      v_vSQL := v_vSQL || 'order by t.toolbar_sort_order, t.menu_item_id ';
    else
      v_vSQL := 'select * ';
      v_vSQL := v_vSQL || 'from tbicds.stat_menu_items t ';
      v_vSQL := v_vSQL || 'where t.active = 1 ';
      --v_vSQL := v_vSQL || 'and t.has_parent = 1 ';
      v_vSQL := v_vSQL || 'and t.is_logged_in = 0 ';
      v_vSQL := v_vSQL || 'and ((t.user_right = :USER_RIGHTS) or (t.user_type = :USER_TYPE)) ';
      v_vSQL := v_vSQL || 'and (bitand(2, t.item_type) > 0) ';
      v_vSQL := v_vSQL || 'order by t.toolbar_sort_order, t.menu_item_id ';
    end if;
  
    open rs for v_vSQL using v_nUserRights, v_nUserType;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_APP_MENU.GetToolbarItemsRS(): ' || sqlErrm;
  end;
  
  /*****
  Gets Menu Root Items
  *****/
  procedure GetMenuRootLevelRS(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               pi_nAppID           in number,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2,
                               rs                  out sys_refcursor) 
 is
    v_vSQL         varchar2(32767) := '';
    v_vTitleColumn varchar2(24) := 'item_title';
    v_nLangPref    number;

  begin
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';

    v_nLangPref := fnGetLangPref(pi_nUserID);
  
    v_vSQL := v_vSQL || '       select t.*, ';
    
    if v_nLangPref = 1 then
      v_vTitleColumn := 'item_title';
      v_vSQL := v_vSQL || '  t.item_title as title ';
    elsif v_nLangPref = 2 then
      v_vTitleColumn := 'alternate_language';
      v_vSQL := v_vSQL || '  t.alternate_language as title ';
    end if;
   
    v_vSQL := v_vSQL || '         from app_menu_items t ';
    v_vSQL := v_vSQL || '        where t.active = 1 ';
    v_vSQL := v_vSQL || '          and t.parent_item = 0';
    v_vSQL := v_vSQL || '          and (bitand(' || '(:pi_nAppID)' ||
              ', t.target_app) > 0) ';
    v_vSQL := v_vSQL || '        order by t.sort_order ';

    open rs for v_vSQL using pi_nAppID;

  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_APP_MENU.GetMenuRootLevelRS(): ' || sqlErrm;
  end;

  /*****
  Gets Menu Child Items
  *****/
  procedure GetMenuChildItemsRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nAppID           in number,
                                pi_nItemID          in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out sys_refcursor) 
  is
  
    v_vSQL         varchar2(32767) := '';
    v_vTitleColumn varchar2(24) := 'item_title';
    v_nLangPref    number;

  begin
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';

    v_nLangPref := fnGetLangPref(pi_nUserID);

    v_vSQL := v_vSQL || '       select t.*, ';
  
   if v_nLangPref = 1 then
      v_vTitleColumn := 'item_title';
      v_vSQL := v_vSQL || '  t.item_title as title ';
    elsif v_nLangPref = 2 then
      v_vTitleColumn := 'alternate_language';
      v_vSQL := v_vSQL || '  t.alternate_language as title ';
    end if;
    
    v_vSQL := v_vSQL || '         from app_menu_items t ';
    v_vSQL := v_vSQL || '        where t.active = 1 ';
    v_vSQL := v_vSQL || '          and t.parent_item = :pi_nItemID ';
    v_vSQL := v_vSQL || '          and (bitand(' || ':pi_nAppID' ||
              ', t.target_app) > 0) ';
    v_vSQL := v_vSQL || '        order by t.sort_order ';

    open rs for v_vSQL using pi_nItemID, pi_nAppID;

  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_APP_MENU.GetMenuChildItemsRS(): ' ||
                           sqlErrm;
  end;

  /*****
  Get all menu items for a specific app id
  *****/
  procedure GetAllMenuItemsRS(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_nAppID           in number,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2,
                              rs                  out sys_refcursor) 
  is
    v_vSQL         varchar2(32767) := '';
    v_vTitleColumn varchar2(24) := 'item_title';
    v_nLangPref    number;

  begin
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';

    v_nLangPref := fnGetLangPref(pi_nUserID);
   
    v_vSQL := v_vSQL || '       select t.*, ';
    
    if v_nLangPref = 1 then
      v_vTitleColumn := 'item_title';
      v_vSQL := v_vSQL || '  t.item_title as title ';
    elsif v_nLangPref = 2 then
      v_vTitleColumn := 'alternate_language';
      v_vSQL := v_vSQL || '  t.alternate_language as title ';
    end if;
 
    v_vSQL := v_vSQL || '         from app_menu_items t ';
    v_vSQL := v_vSQL || '        where t.active = 1 ';
    v_vSQL := v_vSQL || '          and (bitand(' || ':pi_nAppID' ||
              ', t.target_app) > 0) ';
    v_vSQL := v_vSQL || '        order by t.sort_order ';

    open rs for v_vSQL using pi_nAppID;

  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_APP_MENU.GetAllMenuItemsRS(): ' || sqlErrm;
  end;

  function fnGetLangPref(pi_nUserID in number) return number is
    v_nResult number := 1;
  begin
    return v_nResult;
  end;

end PCK_APP_MENU2;
/

